package com.tomas.ht_ydt;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.TextView;

//import com.tomas.ht_ydt.ListData.Data;
import com.tomas.ht_ydt.ListData.Data;

import java.util.ArrayList;

public class SearchMyAdapter extends BaseAdapter implements Filterable {
    Context context;
    public ArrayList<Data> data;
    LayoutInflater inflater;
    SearchFilters filter;
    ArrayList<Data> filteredList;
    ItemClickListener_Search itemClickListener;

    public SearchMyAdapter(Context context, ArrayList<Data> data, ItemClickListener_Search itemClickListener) {
        this.context = context;
        this.data = data;
        this.filteredList = data;
        this.itemClickListener = itemClickListener;
    }

    @Override
    public int getCount() {
        return data.size();
    }

    @Override
    public Object getItem(int position) {
        return data.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        if (inflater == null) {
            inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        }
        if (convertView == null) {
            convertView = inflater.inflate(R.layout.model, null);
        }

        // Binding Data
        TextView nameTxt = convertView.findViewById(R.id.movie_title);
        nameTxt.setText(data.get(position).getItem());

        convertView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                // ส่งข้อความกลับไปยัง MainActivity
                itemClickListener.OnItemClicked(data.get(position).getItem());
            }
        });

        return convertView;
    }

    @Override
    public Filter getFilter() {
        if (filter == null) {
            filter = new SearchFilters(filteredList, this);
        }
        return filter;
    }
}
